% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ggplot2.R, R/wrap.R
\docType{methods}
\name{envelopes}
\alias{envelopes}
\alias{wrap_hull}
\alias{wrap_hull-method}
\alias{stat_hull}
\alias{wrap_hull,MultivariateAnalysis-method}
\alias{wrap_hull,BootstrapPCA-method}
\title{Wrap Observations}
\usage{
wrap_hull(x, ...)

stat_hull(
  mapping = NULL,
  data = NULL,
  geom = "polygon",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

\S4method{wrap_hull}{MultivariateAnalysis}(x, margin = 1, axes = c(1, 2), group = NULL)

\S4method{wrap_hull}{BootstrapPCA}(x, axes = c(1, 2))
}
\arguments{
\item{x}{An object from which to wrap observations (a \code{\linkS4class{CA}} or
\code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values be silently removed?
If \code{FALSE} (the ), missing values are removed with a warning.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions
to be for which to compute results.}

\item{group}{A vector specifying the group an observation belongs to.}
}
\value{
\itemize{
\item \code{stat_hull()} return a \code{\link[ggplot2:layer]{ggplot2::layer()}}.
\item \code{wrap_hull()} return a \code{\link{data.frame}} of
envelope principal coordinates. An extra column named \code{group} is added
specifying the group an observation belongs to.
}
}
\description{
\itemize{
\item \code{wrap_hull()} computes convex hull of a set of observations.
}
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE)

## Plot results
plot_rows(X, colour = "group", group = iris$Species) +
    khroma::scale_colour_highcontrast()

## Convex hull coordinates
hulls <- wrap_hull(X, group = iris$Species)
head(hulls)

## Plot with convex hulls
plot_rows(X, colour = "group", group = iris$Species) +
  stat_hull(geom = "path") +
  khroma::scale_colour_highcontrast()
}
\references{
\url{https://ggplot2.tidyverse.org/articles/extending-ggplot2.html}
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{plot_contributions}()},
\code{\link{plot_coordinates}},
\code{\link{plot_eigenvalues}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
