% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lma_functions.R
\name{calc_lma}
\alias{calc_lma}
\title{Generate leaf mass per area results}
\usage{
calc_lma(data, params, resolution = "species")
}
\arguments{
\item{data}{Must include "petiole metric" or some combination of columns to
calculate petiole metric such as "Blade Area", "Petiole Area", and "Petiole Width",
or "Leaf Area" and "Petiole Width".  If calculating morphospecies-mean LMA,
must include "Site" and "Morphotype" columns. If calculating species-mean LMA,
only needs to include a "Site' column.}

\item{params}{A list of regression parameters. Must contain "stat" (= "mean" or = "variance"),
"regression_slope", "y_intercept", "unexplained_mean_square", "sample_size_calibration"
"mean_log_petiole_metric_calibration", "sum_of_squares_calibration", and "critical_value".

Pre-loaded sets of parameters:

\describe{
\item{"royer_species_mean_ma":}{
\itemize{
\item stat = "mean",
\item regression_slope = 0.382,
\item y_intercept = 3.070,
\item unexplained_mean_square = 0.032237,
\item sample_size_calibration = 667,
\item mean_log_petiole_metric_calibration = -3.011,
\item sum_of_squares_calibration = 182.1,
\item critical_value = 1.964}
}

\item{"royer_site_mean_ma":}{
\itemize{
\item stat = "mean",
\item regression_slope = 0.429,
\item y_intercept = 3.214,
\item unexplained_mean_square = 0.005285,
\item sample_size_calibration = 25,
\item mean_log_petiole_metric_calibration = -2.857,
\item sum_of_squares_calibration = 5.331,
\item critical_value = 2.069}
}

\item{"lowe_site_mean_ma":}{
\itemize{
\item stat = "mean",
\item regression_slope = 0.345,
\item y_intercept = 2.954,
\item unexplained_mean_square = 0.01212861,
\item sample_size_calibration = 70,
\item mean_log_petiole_metric_calibration = -2.902972,
\item sum_of_squares_calibration = 1.154691,
\item critical_value = 1.995469}
}

\item{"lowe_site_variance_ma":}{
\itemize{
\item stat = "variance",
\item regression_slope = 0.302,
\item y_intercept = 5.028,
\item unexplained_mean_square = 0.1713672,
\item sample_size_calibration = 70,
\item mean_log_petiole_metric_calibration = -5.97104,
\item sum_of_squares_calibration = 5.085184,
\item critical_value = 1.995469}
}
}}

\item{resolution}{Either "species" or "site".  Informs whether the function
should calculate morphospecies-mean LMA values ("species") or site-mean/site-
variance LMA values ("site").  If resolution = "site", data must already be
in the form of species-mean LMA.}
}
\value{
A table with LMA results
}
\description{
\code{calc_lma()} will typically only be called internally by \code{\link[=lma]{lma()}}. It provides
the flexibility to use custom regression parameters to calculate leaf mass
per area (LMA).
}
\examples{
# Calculate morphospecies-mean LMA values with the parameters from Royer et al. (2007)
results <- calc_lma(McAbeeExample,
  params = list(
    stat = "mean",
    regression_slope = 0.382,
    y_intercept = 3.070,
    unexplained_mean_square = 0.032237,
    sample_size_calibration = 667,
    mean_log_petiole_metric_calibration = -3.011,
    sum_of_squares_calibration = 182.1,
    critical_value = 1.964
  ),
  resolution = "species"
)
results

# Calculate site-mean LMA values with the parameters from Lowe et al. (2024) entered from scratch
site_results <- calc_lma(results,
  params = list(
    stat = "mean",
    regression_slope = 0.345,
    y_intercept = 2.954,
    unexplained_mean_square = 0.01212861,
    sample_size_calibration = 70,
    mean_log_petiole_metric_calibration = -2.902972,
    sum_of_squares_calibration = 1.154691,
    critical_value = 1.995469
  ),
  resolution = "site"
)
site_results

}
\references{
\itemize{
\item Royer, D. L., L. Sack, P. Wilf, C. H. Lusk, G. J. Jordan, Ulo Niinemets, I. J. Wright, et al. 2007. Fossil Leaf Economics Quantified: Calibration, Eocene Case Study, and Implications. Paleobiology 33: 574–589
\item Lowe, A. J., D. L. Royer, D. J. Wieczynski, M. J. Butrim, T. Reichgelt, L. Azevedo-Schmidt, D. J. Peppe, et al. 2024. Global patterns in community-scale leaf mass per area distributions of woody non-monocot angiosperms and their utility in the fossil record. In review.
}
}
