% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{coef.ddfMLR}
\alias{coef.ddfMLR}
\alias{coefficients.ddfMLR}
\title{Extract model coefficients from an object of \code{"ddfMLR"} class.}
\usage{
\method{coef}{ddfMLR}(object, SE = FALSE, simplify = FALSE, ...)
}
\arguments{
\item{object}{an object of \code{"ddfMLR"} class.}

\item{SE}{logical: should the standard errors of estimated parameters be also returned? (default is \code{FALSE}).}

\item{simplify}{logical: should the estimated parameters be simplified to a matrix? (default is \code{FALSE}).}

\item{...}{other generic parameters for \code{coef()} method.}
}
\description{
S3 method for extracting estimated model coefficients from an object of \code{"ddfMLR"} class.
}
\examples{
\dontrun{
# Loading data based on GMAT
data(GMATtest, GMATkey)

Data <- GMATtest[, 1:20]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# Estimated parameters
coef(x)
coef(x, SE = TRUE)
coef(x, simplify = TRUE)
coef(x, SE = TRUE, simplify = TRUE)
}
}
\seealso{
\code{\link[difNLR]{ddfMLR}} for DDF detection among nominal data. \cr
\code{\link[stats]{coef}} for generic function extracting model coefficients.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
