% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acoustic_distance.R
\name{acoustic_distance}
\alias{acoustic_distance}
\title{Acoustic distance based on Mel-Frequency Cepstral Coefficients}
\usage{
acoustic_distance(file1, file2)
}
\arguments{
\item{file1}{The file to compare, which should be in the Waveform Audio File Format (i.e. wav).}

\item{file2}{The other audio file to compare against, again as a wav.}
}
\value{
A number, indicating the distance between the two audio files.
}
\description{
This function implements an acoustic distance based on Mel-Frequency Cepstral Coefficients, upon which dynamic time warping is used to produce the results, as proposed by Bartelds et al. (2020). With an input of two audio files in the Waveform Audio File Format (i.e. wav), the function will return a distance between the two audios.
}
\examples{
# Example 1: The acoustic distance between i and e

i_audio <- system.file("extdata", "i.wav", package="dialectR")
e_audio <- system.file("extdata", "e.wav", package="dialectR")
try(acoustic_distance(i_audio, e_audio),
 message("Python not available for testing"),
 silent = TRUE)
}
\references{
Bartelds, M., Richter, C., Liberman, M., and Wieling, M. 2020. A New Acoustic-Based
Pronunciation Distance Measure. \emph{Frontiers in Artificial Intelligence}, 3, May. \doi{10.3389/frai.2020.00039}
}
