% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.coef.dfrr.R
\name{plot.coef.dfrr}
\alias{plot.coef.dfrr}
\title{Plot dfrr coefficients}
\usage{
\method{plot}{coef.dfrr}(x, select = NULL, ask.hit.return = TRUE, ...)
}
\arguments{
\item{x}{a \code{coef.dfrr}-object.}

\item{select}{a vector of length one or more of indices of regression
coefficients to plot.}

\item{ask.hit.return}{a boolean indicating whether to wait for interaction of the user between any two plots.}

\item{...}{graphical parameters passed to \code{plot}.}
}
\value{
This function generates the plot of functional regression coefficients.
}
\description{
Plot a  \code{coef.dfrr} object. The output is the plot of regression coefficients.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
coefs<-coef(dfrr_fit)
plot(coefs)

}
