
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_cdf_reg_dtox_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_cdf_reg_dtox");
    reader.add_event(24, 22, "end", "model_cdf_reg_dtox");
    return reader;
}

class model_cdf_reg_dtox : public prob_grad {
private:
    int N;
    vector<int> y;
    vector<double> dose;
    vector<double> beta0mean;
    vector<double> beta1mean;
public:
    model_cdf_reg_dtox(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_cdf_reg_dtox(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_cdf_reg_dtox_namespace::model_cdf_reg_dtox";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(N));
            validate_non_negative_index("dose", "N", N);
            dose = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < dose_limit_0__; ++i_0__) {
                dose[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("beta0mean", "2", 2);
            context__.validate_dims("data initialization", "beta0mean", "double", context__.to_vec(2));
            validate_non_negative_index("beta0mean", "2", 2);
            beta0mean = std::vector<double>(2,double(0));
            vals_r__ = context__.vals_r("beta0mean");
            pos__ = 0;
            size_t beta0mean_limit_0__ = 2;
            for (size_t i_0__ = 0; i_0__ < beta0mean_limit_0__; ++i_0__) {
                beta0mean[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("beta1mean", "2", 2);
            context__.validate_dims("data initialization", "beta1mean", "double", context__.to_vec(2));
            validate_non_negative_index("beta1mean", "2", 2);
            beta1mean = std::vector<double>(2,double(0));
            vals_r__ = context__.vals_r("beta1mean");
            pos__ = 0;
            size_t beta1mean_limit_0__ = 2;
            for (size_t i_0__ = 0; i_0__ < beta1mean_limit_0__; ++i_0__) {
                beta1mean[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_cdf_reg_dtox() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta0")))
            throw std::runtime_error("variable beta0 missing");
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta0", "double", context__.to_vec());
        double beta0(0);
        beta0 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(get_base1(beta0mean,1,"beta0mean",1),get_base1(beta0mean,2,"beta0mean",1),beta0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta0: ") + e.what());
        }

        if (!(context__.contains_r("beta1")))
            throw std::runtime_error("variable beta1 missing");
        vals_r__ = context__.vals_r("beta1");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta1", "double", context__.to_vec());
        double beta1(0);
        beta1 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1),beta1);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta1: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.scalar_lub_constrain(get_base1(beta0mean,1,"beta0mean",1),get_base1(beta0mean,2,"beta0mean",1),lp__);
            else
                beta0 = in__.scalar_lub_constrain(get_base1(beta0mean,1,"beta0mean",1),get_base1(beta0mean,2,"beta0mean",1));

            local_scalar_t__ beta1;
            (void) beta1;  // dummy to suppress unused var warning
            if (jacobian__)
                beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1),lp__);
            else
                beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1));


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("p", "N", N);
            vector<local_scalar_t__> p(N);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("z", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  z(static_cast<Eigen::VectorXd::Index>(N));
            (void) z;  // dummy to suppress unused var warning

            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {

                stan::model::assign(z, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (-(beta0) + (get_base1(dose,n,"dose",1) * beta1)), 
                            "assigning variable z");
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_cdf(get_base1(z,n,"z",1),0,1), 
                            "assigning variable p");
            }
            lp_accum__.add(bernoulli_log<propto__>(y, p));
            lp_accum__.add(uniform_log<propto__>(beta0, get_base1(beta0mean,1,"beta0mean",1), get_base1(beta0mean,2,"beta0mean",1)));
            lp_accum__.add(uniform_log<propto__>(beta1, get_base1(beta1mean,1,"beta1mean",1), get_base1(beta1mean,2,"beta1mean",1)));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta0");
        names__.push_back("beta1");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_cdf_reg_dtox_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta0 = in__.scalar_lub_constrain(get_base1(beta0mean,1,"beta0mean",1),get_base1(beta0mean,2,"beta0mean",1));
        double beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1));
        vars__.push_back(beta0);
        vars__.push_back(beta1);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_cdf_reg_dtox";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta1";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta1";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_cdf_reg_pktox_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_cdf_reg_pktox");
    reader.add_event(24, 22, "end", "model_cdf_reg_pktox");
    return reader;
}

class model_cdf_reg_pktox : public prob_grad {
private:
    int N;
    vector<int> y;
    vector<double> dose;
    double beta2mean;
    double beta3mean;
public:
    model_cdf_reg_pktox(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_cdf_reg_pktox(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_cdf_reg_pktox_namespace::model_cdf_reg_pktox";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(N));
            validate_non_negative_index("dose", "N", N);
            dose = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < dose_limit_0__; ++i_0__) {
                dose[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "beta2mean", "double", context__.to_vec());
            beta2mean = double(0);
            vals_r__ = context__.vals_r("beta2mean");
            pos__ = 0;
            beta2mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta3mean", "double", context__.to_vec());
            beta3mean = double(0);
            vals_r__ = context__.vals_r("beta3mean");
            pos__ = 0;
            beta3mean = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_cdf_reg_pktox() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta2")))
            throw std::runtime_error("variable beta2 missing");
        vals_r__ = context__.vals_r("beta2");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta2", "double", context__.to_vec());
        double beta2(0);
        beta2 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta2mean,beta2);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2: ") + e.what());
        }

        if (!(context__.contains_r("beta3")))
            throw std::runtime_error("variable beta3 missing");
        vals_r__ = context__.vals_r("beta3");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta3", "double", context__.to_vec());
        double beta3(0);
        beta3 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta3mean,beta3);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta3: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ beta2;
            (void) beta2;  // dummy to suppress unused var warning
            if (jacobian__)
                beta2 = in__.scalar_lub_constrain(0,beta2mean,lp__);
            else
                beta2 = in__.scalar_lub_constrain(0,beta2mean);

            local_scalar_t__ beta3;
            (void) beta3;  // dummy to suppress unused var warning
            if (jacobian__)
                beta3 = in__.scalar_lub_constrain(0,beta3mean,lp__);
            else
                beta3 = in__.scalar_lub_constrain(0,beta3mean);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("p", "N", N);
            vector<local_scalar_t__> p(N);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("z", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  z(static_cast<Eigen::VectorXd::Index>(N));
            (void) z;  // dummy to suppress unused var warning

            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {

                stan::model::assign(z, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (-(beta2) + (get_base1(dose,n,"dose",1) * beta3)), 
                            "assigning variable z");
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            normal_cdf(get_base1(z,n,"z",1),0,1), 
                            "assigning variable p");
            }
            lp_accum__.add(bernoulli_log<propto__>(y, p));
            lp_accum__.add(uniform_log<propto__>(beta2, 0.0, beta2mean));
            lp_accum__.add(uniform_log<propto__>(beta3, 0.0, beta3mean));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta2");
        names__.push_back("beta3");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_cdf_reg_pktox_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta2 = in__.scalar_lub_constrain(0,beta2mean);
        double beta3 = in__.scalar_lub_constrain(0,beta3mean);
        vars__.push_back(beta2);
        vars__.push_back(beta3);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_cdf_reg_pktox";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_logit_reg_pkcov_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_logit_reg_pkcov");
    reader.add_event(27, 25, "end", "model_logit_reg_pkcov");
    return reader;
}

class model_logit_reg_pkcov : public prob_grad {
private:
    int N;
    vector<int> y;
    vector<double> dose;
    vector_d dauc;
    double beta0mean;
    vector<double> beta1mean;
public:
    model_logit_reg_pkcov(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_logit_reg_pkcov(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_logit_reg_pkcov_namespace::model_logit_reg_pkcov";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(N));
            validate_non_negative_index("dose", "N", N);
            dose = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < dose_limit_0__; ++i_0__) {
                dose[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("dauc", "N", N);
            context__.validate_dims("data initialization", "dauc", "vector_d", context__.to_vec(N));
            validate_non_negative_index("dauc", "N", N);
            dauc = vector_d(static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("dauc");
            pos__ = 0;
            size_t dauc_i_vec_lim__ = N;
            for (size_t i_vec__ = 0; i_vec__ < dauc_i_vec_lim__; ++i_vec__) {
                dauc[i_vec__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "beta0mean", "double", context__.to_vec());
            beta0mean = double(0);
            vals_r__ = context__.vals_r("beta0mean");
            pos__ = 0;
            beta0mean = vals_r__[pos__++];
            validate_non_negative_index("beta1mean", "2", 2);
            context__.validate_dims("data initialization", "beta1mean", "double", context__.to_vec(2));
            validate_non_negative_index("beta1mean", "2", 2);
            beta1mean = std::vector<double>(2,double(0));
            vals_r__ = context__.vals_r("beta1mean");
            pos__ = 0;
            size_t beta1mean_limit_0__ = 2;
            for (size_t i_0__ = 0; i_0__ < beta1mean_limit_0__; ++i_0__) {
                beta1mean[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_logit_reg_pkcov() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta0")))
            throw std::runtime_error("variable beta0 missing");
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta0", "double", context__.to_vec());
        double beta0(0);
        beta0 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,25,beta0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta0: ") + e.what());
        }

        if (!(context__.contains_r("beta1")))
            throw std::runtime_error("variable beta1 missing");
        vals_r__ = context__.vals_r("beta1");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta1", "double", context__.to_vec());
        double beta1(0);
        beta1 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1),beta1);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta1: ") + e.what());
        }

        if (!(context__.contains_r("beta2")))
            throw std::runtime_error("variable beta2 missing");
        vals_r__ = context__.vals_r("beta2");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta2", "double", context__.to_vec());
        double beta2(0);
        beta2 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,5,beta2);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.scalar_lub_constrain(0,25,lp__);
            else
                beta0 = in__.scalar_lub_constrain(0,25);

            local_scalar_t__ beta1;
            (void) beta1;  // dummy to suppress unused var warning
            if (jacobian__)
                beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1),lp__);
            else
                beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1));

            local_scalar_t__ beta2;
            (void) beta2;  // dummy to suppress unused var warning
            if (jacobian__)
                beta2 = in__.scalar_lub_constrain(0,5,lp__);
            else
                beta2 = in__.scalar_lub_constrain(0,5);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("p", "N", N);
            vector<local_scalar_t__> p(N);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("z", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  z(static_cast<Eigen::VectorXd::Index>(N));
            (void) z;  // dummy to suppress unused var warning

            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {

                stan::model::assign(z, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            ((beta0 - (get_base1(dose,n,"dose",1) * beta1)) - (beta2 * get_base1(dauc,n,"dauc",1))), 
                            "assigning variable z");
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (1 / (1 + stan::math::exp(get_base1(z,n,"z",1)))), 
                            "assigning variable p");
            }
            lp_accum__.add(bernoulli_log<propto__>(y, p));
            lp_accum__.add(uniform_log<propto__>(beta0, 0.0, 25));
            lp_accum__.add(uniform_log<propto__>(beta1, get_base1(beta1mean,1,"beta1mean",1), get_base1(beta1mean,2,"beta1mean",1)));
            lp_accum__.add(uniform_log<propto__>(beta2, 0.0, 5));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta0");
        names__.push_back("beta1");
        names__.push_back("beta2");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_logit_reg_pkcov_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta0 = in__.scalar_lub_constrain(0,25);
        double beta1 = in__.scalar_lub_constrain(get_base1(beta1mean,1,"beta1mean",1),get_base1(beta1mean,2,"beta1mean",1));
        double beta2 = in__.scalar_lub_constrain(0,5);
        vars__.push_back(beta0);
        vars__.push_back(beta1);
        vars__.push_back(beta2);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_logit_reg_pkcov";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_logit_reg_pklogit_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_logit_reg_pklogit");
    reader.add_event(24, 22, "end", "model_logit_reg_pklogit");
    return reader;
}

class model_logit_reg_pklogit : public prob_grad {
private:
    int N;
    vector<int> y;
    vector<double> dose;
    double beta2mean;
    double beta3mean;
public:
    model_logit_reg_pklogit(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_logit_reg_pklogit(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_logit_reg_pklogit_namespace::model_logit_reg_pklogit";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(N));
            validate_non_negative_index("dose", "N", N);
            dose = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < dose_limit_0__; ++i_0__) {
                dose[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "beta2mean", "double", context__.to_vec());
            beta2mean = double(0);
            vals_r__ = context__.vals_r("beta2mean");
            pos__ = 0;
            beta2mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta3mean", "double", context__.to_vec());
            beta3mean = double(0);
            vals_r__ = context__.vals_r("beta3mean");
            pos__ = 0;
            beta3mean = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_logit_reg_pklogit() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta2")))
            throw std::runtime_error("variable beta2 missing");
        vals_r__ = context__.vals_r("beta2");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta2", "double", context__.to_vec());
        double beta2(0);
        beta2 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta2mean,beta2);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta2: ") + e.what());
        }

        if (!(context__.contains_r("beta3")))
            throw std::runtime_error("variable beta3 missing");
        vals_r__ = context__.vals_r("beta3");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta3", "double", context__.to_vec());
        double beta3(0);
        beta3 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta3mean,beta3);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta3: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ beta2;
            (void) beta2;  // dummy to suppress unused var warning
            if (jacobian__)
                beta2 = in__.scalar_lub_constrain(0,beta2mean,lp__);
            else
                beta2 = in__.scalar_lub_constrain(0,beta2mean);

            local_scalar_t__ beta3;
            (void) beta3;  // dummy to suppress unused var warning
            if (jacobian__)
                beta3 = in__.scalar_lub_constrain(0,beta3mean,lp__);
            else
                beta3 = in__.scalar_lub_constrain(0,beta3mean);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("p", "N", N);
            vector<local_scalar_t__> p(N);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("z", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  z(static_cast<Eigen::VectorXd::Index>(N));
            (void) z;  // dummy to suppress unused var warning

            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {

                stan::model::assign(z, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (beta2 - (get_base1(dose,n,"dose",1) * beta3)), 
                            "assigning variable z");
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (1 / (1 + stan::math::exp(get_base1(z,n,"z",1)))), 
                            "assigning variable p");
            }
            lp_accum__.add(bernoulli_log<propto__>(y, p));
            lp_accum__.add(uniform_log<propto__>(beta2, 0.0, beta2mean));
            lp_accum__.add(uniform_log<propto__>(beta3, 0.0, beta3mean));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta2");
        names__.push_back("beta3");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_logit_reg_pklogit_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta2 = in__.scalar_lub_constrain(0,beta2mean);
        double beta3 = in__.scalar_lub_constrain(0,beta3mean);
        vars__.push_back(beta2);
        vars__.push_back(beta3);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_logit_reg_pklogit";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_logit_reg_pkpop_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_logit_reg_pkpop");
    reader.add_event(24, 22, "end", "model_logit_reg_pkpop");
    return reader;
}

class model_logit_reg_pkpop : public prob_grad {
private:
    int N;
    vector<int> y;
    vector<double> dose;
    double beta3mean;
    double beta4mean;
public:
    model_logit_reg_pkpop(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_logit_reg_pkpop(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_logit_reg_pkpop_namespace::model_logit_reg_pkpop";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec(N));
            validate_non_negative_index("dose", "N", N);
            dose = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < dose_limit_0__; ++i_0__) {
                dose[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "beta3mean", "double", context__.to_vec());
            beta3mean = double(0);
            vals_r__ = context__.vals_r("beta3mean");
            pos__ = 0;
            beta3mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta4mean", "double", context__.to_vec());
            beta4mean = double(0);
            vals_r__ = context__.vals_r("beta4mean");
            pos__ = 0;
            beta4mean = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_logit_reg_pkpop() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta3")))
            throw std::runtime_error("variable beta3 missing");
        vals_r__ = context__.vals_r("beta3");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta3", "double", context__.to_vec());
        double beta3(0);
        beta3 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta3mean,beta3);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta3: ") + e.what());
        }

        if (!(context__.contains_r("beta4")))
            throw std::runtime_error("variable beta4 missing");
        vals_r__ = context__.vals_r("beta4");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta4", "double", context__.to_vec());
        double beta4(0);
        beta4 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,beta4mean,beta4);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta4: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ beta3;
            (void) beta3;  // dummy to suppress unused var warning
            if (jacobian__)
                beta3 = in__.scalar_lub_constrain(0,beta3mean,lp__);
            else
                beta3 = in__.scalar_lub_constrain(0,beta3mean);

            local_scalar_t__ beta4;
            (void) beta4;  // dummy to suppress unused var warning
            if (jacobian__)
                beta4 = in__.scalar_lub_constrain(0,beta4mean,lp__);
            else
                beta4 = in__.scalar_lub_constrain(0,beta4mean);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body
            {
            validate_non_negative_index("p", "N", N);
            vector<local_scalar_t__> p(N);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("z", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  z(static_cast<Eigen::VectorXd::Index>(N));
            (void) z;  // dummy to suppress unused var warning

            stan::math::initialize(z, DUMMY_VAR__);
            stan::math::fill(z,DUMMY_VAR__);


            for (int n = 1; n <= N; ++n) {

                stan::model::assign(z, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (beta3 - (get_base1(dose,n,"dose",1) * beta4)), 
                            "assigning variable z");
                stan::model::assign(p, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            (1 / (1 + stan::math::exp(get_base1(z,n,"z",1)))), 
                            "assigning variable p");
            }
            lp_accum__.add(bernoulli_log<propto__>(y, p));
            lp_accum__.add(uniform_log<propto__>(beta3, 0.0, beta3mean));
            lp_accum__.add(uniform_log<propto__>(beta4, 0.0, beta4mean));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta3");
        names__.push_back("beta4");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_logit_reg_pkpop_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta3 = in__.scalar_lub_constrain(0,beta3mean);
        double beta4 = in__.scalar_lub_constrain(0,beta4mean);
        vars__.push_back(beta3);
        vars__.push_back(beta4);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_logit_reg_pkpop";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta4";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta3";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta4";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_reg_auc_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_reg_auc");
    reader.add_event(19, 17, "end", "model_reg_auc");
    return reader;
}

class model_reg_auc : public prob_grad {
private:
    int N;
    vector_d auc;
    matrix_d dose;
    double beta0;
    double mu;
public:
    model_reg_auc(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_reg_auc(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_reg_auc_namespace::model_reg_auc";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("auc", "N", N);
            context__.validate_dims("data initialization", "auc", "vector_d", context__.to_vec(N));
            validate_non_negative_index("auc", "N", N);
            auc = vector_d(static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("auc");
            pos__ = 0;
            size_t auc_i_vec_lim__ = N;
            for (size_t i_vec__ = 0; i_vec__ < auc_i_vec_lim__; ++i_vec__) {
                auc[i_vec__] = vals_r__[pos__++];
            }
            validate_non_negative_index("dose", "N", N);
            validate_non_negative_index("dose", "2", 2);
            context__.validate_dims("data initialization", "dose", "matrix_d", context__.to_vec(N,2));
            validate_non_negative_index("dose", "N", N);
            validate_non_negative_index("dose", "2", 2);
            dose = matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(2));
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            size_t dose_m_mat_lim__ = N;
            size_t dose_n_mat_lim__ = 2;
            for (size_t n_mat__ = 0; n_mat__ < dose_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < dose_m_mat_lim__; ++m_mat__) {
                    dose(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            context__.validate_dims("data initialization", "beta0", "double", context__.to_vec());
            beta0 = double(0);
            vals_r__ = context__.vals_r("beta0");
            pos__ = 0;
            beta0 = vals_r__[pos__++];
            context__.validate_dims("data initialization", "mu", "double", context__.to_vec());
            mu = double(0);
            vals_r__ = context__.vals_r("mu");
            pos__ = 0;
            mu = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            validate_non_negative_index("b", "2", 2);
            num_params_r__ += 2;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_reg_auc() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b")))
            throw std::runtime_error("variable b missing");
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        validate_non_negative_index("b", "2", 2);
        context__.validate_dims("initialization", "b", "vector_d", context__.to_vec(2));
        vector_d b(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            b(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(b);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  b;
            (void) b;  // dummy to suppress unused var warning
            if (jacobian__)
                b = in__.vector_constrain(2,lp__);
            else
                b = in__.vector_constrain(2);

            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lub_constrain(0,1,lp__);
            else
                sigma = in__.scalar_lub_constrain(0,1);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body

            lp_accum__.add(normal_log<propto__>(auc, multiply(dose,b), sigma));
            lp_accum__.add(beta_log<propto__>(sigma, 1, 1));
            lp_accum__.add(normal_log<propto__>(get_base1(b,1,"b",1), mu, beta0));
            lp_accum__.add(normal_log<propto__>(get_base1(b,2,"b",1), 1, beta0));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b");
        names__.push_back("sigma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_reg_auc_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d b = in__.vector_constrain(2);
        double sigma = in__.scalar_lub_constrain(0,1);
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(b[k_0__]);
            }
        vars__.push_back(sigma);

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters
            if (include_tparams__) {
            }
            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_reg_auc";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
        }


        if (!include_gqs__) return;
    }

}; // model

}




#endif
