% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{dose-class}
\alias{dose-class}
\title{An S4 class to present the next recommended dose level in an ongoing trial.}
\description{
An S4 class to present the next recommended dose level in an ongoing trial.
}
\section{Slots}{

\describe{
\item{\code{N}}{The total number of enrolled patients.}

\item{\code{y}}{The toxicity outcome of each patient.}

\item{\code{AUCs}}{A vector with the computed AUC values of each patient.}

\item{\code{doses}}{The doses levels of the drug.}

\item{\code{x}}{A vector of dose levels assigned to patients in the trial.}

\item{\code{theta}}{The toxicity (probability) target.}

\item{\code{options}}{The Stan model's options.}

\item{\code{newDose}}{The next recommended dose level.}

\item{\code{pstim}}{The estimated mean probabilities of toxicity.}

\item{\code{pstimQ1}}{The 1st quartile of estimated probability of toxicity.}

\item{\code{pstimQ3}}{The 3rd quartile of estimated probability of toxicity.}

\item{\code{parameters}}{The Stan model's estimated parameters.}

\item{\code{model}}{A character string to specify the working model used in the method.}
}}

