% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_plot.R
\name{design_plot}
\alias{design_plot}
\title{Plot the routing design of mst tests}
\usage{
design_plot(db, predicate = NULL, ...)
}
\arguments{
\item{db}{dexterMST project database connection}

\item{predicate}{logical predicate to select data (tests, booklets,responses) to include in the design plot}

\item{...}{further arguments to \code{\link[igraph]{plot.igraph}}, see: \code{\link[igraph]{igraph.plotting}}}
}
\description{
Plot the routing design of mst tests
}
\details{
You can use this function to plot routing designs for tests before or after
they are administered. There are some slight differences.

If you have entered response data already, the thickness of the line will indicate the numbers
of respondents that took the respective paths through the test. Paths not taken will not be drawn. You can use the
predicate (see examples) to include or exclude items, tests and respondents.

If you have not entered response data, all lines will have equal thickness. Variables you can use in the predicate
are limited to test_id and booklet_id in this case.
}
\examples{
\dontrun{
# plot test designs for all tests in the project
design_plot(db)

# plot design for a test with id 'math'
design_plot(db, test_id == 'math')

# plot design for test math with item 'circumference' turned off
# (this plot will only work if you have response data)
design_plot(db, test_id == 'math' & item_id != 'circumference')

}

}
