% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{update_packages}
\alias{update_packages}
\title{Update packages that are missing or out-of-date.}
\usage{
update_packages(pkgs = NULL, dependencies = NA,
  repos = getOption("repos"), type = getOption("pkgType"))
}
\arguments{
\item{pkgs}{Character vector of packages to update. If \code{NULL} all
installed packages are updated.}

\item{dependencies}{Which dependencies do you want to check?
  Can be a character vector (selecting from "Depends", "Imports",
   "LinkingTo", "Suggests", or "Enhances"), or a logical vector.

  \code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
  "Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
  and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
  just check this package, not its dependencies).}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.  If "both", will switch
automatically to "binary" to avoid interactive prompts during package
installation.}
}
\description{
Works similarly to \code{install.packages()} but doesn't install packages
that are already installed, and also upgrades out dated dependencies.
}
\examples{
\dontrun{
update_packages("ggplot2")
update_packages(c("plyr", "ggplot2"))
}
}
\seealso{
\code{\link{package_deps}} to see which packages are out of date/
  missing.
}

