% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-cran.r
\name{check_cran}
\alias{check_cran}
\title{Check a package from CRAN.}
\usage{
check_cran(pkgs, libpath = file.path(tempdir(), "R-lib"), srcpath = libpath,
  bioconductor = FALSE, type = getOption("pkgType"),
  threads = getOption("Ncpus", 1), check_dir = tempfile("check_cran"),
  revdep_pkg = NULL)
}
\arguments{
\item{pkgs}{Vector of package names - note that unlike other \pkg{devtools}
functions this is the name of a CRAN package, not a path.}

\item{libpath}{Path to library to store dependencies packages - if you
you're doing this a lot it's a good idea to pick a directory and stick
with it so you don't have to download all the packages every time.}

\item{srcpath}{Path to directory to store source versions of dependent
packages - again, this saves a lot of time because you don't need to
redownload the packages every time you run the package.}

\item{bioconductor}{Include bioconductor packages in checking?}

\item{type}{binary Package type to test (source, mac.binary etc). Defaults
to the same type as \code{\link{install.packages}()}.}

\item{threads}{Number of concurrent threads to use for checking.
It defaults to the option \code{"Ncpus"} or \code{1} if unset.}

\item{check_dir}{Directory to store results.}

\item{revdep_pkg}{Optional name of a package for which this check is
checking the reverse dependencies of. This is normally passed in from
\code{\link{revdep_check}}, and is used only for logging.}
}
\value{
Returns (invisibly) the directory where check results are stored.
}
\description{
Internal function used to power \code{\link{revdep_check}()}.
}
\details{
This function does not clean up after itself, but does work in a
session-specific temporary directory, so all files will be removed
when your current R session ends.
}
\keyword{internal}

