% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{davidson_44}
\alias{davidson_44}
\title{Davidson equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.2307/1326}
}
\usage{
davidson_44
}
\description{
Davidson, J. (1944). On the relationship between temperature and rate of development of insects
at constant temperatures. The Journal of Animal Ecology:26-38.
}
\details{
Equation:
\deqn{rT = \frac{K}{1 + e^{aa + bb * T}}}{%
      rT = K / (1 + exp(aa + bb * T))}

where rT is the development rate, T the temperature, K the distance between
the upper and lower asymptote of the curve, aa the relative position of the origin of
the curve on the abscissa, bb the degree of acceleration of development of the life stage
in relation to temperature.
}
\keyword{datasets}
