% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lactin1_95}
\alias{lactin1_95}
\title{Lactin et al. equation 1 of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1093/ee/24.1.68}
}
\usage{
lactin1_95
}
\description{
Lactin, Derek J, NJ Holliday, DL Johnson, y R Craigen (995) Improved rate model of
temperature-dependent development by arthropods. Environmental Entomology 24(1): 68-75.
}
\details{
Equation:
rT ~ exp(aa * T) - exp(aa * Tmax - (Tmax - T)/deltaT)

where rT is the development rate, T the temperature, and aa, Tmax,
and deltaT fitted parameters.
}
\keyword{datasets}

