% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_functions.R
\name{HDLP}
\alias{HDLP}
\title{High-Dimensional Local Projection}
\usage{
HDLP(
  r = NULL,
  x,
  y,
  q = NULL,
  y_predetermined = FALSE,
  cumulate_y = FALSE,
  hmax = 24,
  lags = 12,
  alphas = 0.05,
  init_partial = TRUE,
  selection = 4,
  PIconstant = 0.8,
  progress_bar = TRUE
)
}
\arguments{
\item{r}{(optional) vector or matrix with \code{T_} rows, containing the "slow" variables, ones which do not react within the same period to a shock, see \insertCite{plagborg2021local;textual}{desla} for details(NULL by default)}

\item{x}{\code{T_}x1 vector containing the shock variable, see \insertCite{plagborg2021local;textual}{desla} for details}

\item{y}{\code{T_}x1 vector containing the response variable, see \insertCite{plagborg2021local;textual}{desla} for details}

\item{q}{(optional) vector or matrix with \code{T_} rows, containing the "fast" variables, ones which may react within the same period to a shock, see \insertCite{plagborg2021local;textual}{desla} for details (NULL by default)}

\item{y_predetermined}{(optional) boolean, true if the response variable \code{y} is predetermined with respect to \code{x}, i.e. cannot react within the same period to the shock. If true, the impulse response at horizon 0 is 0 (false by default)}

\item{cumulate_y}{(optional) boolean, true if the impulse response of \code{y} should be cumulated, i.e. using the cumulative sum of \code{y} as the dependent variable (false by default)}

\item{hmax}{(optional) integer, the maximum horizon up to which the impulse responses are computed. Should not exceed the \code{T_}-\code{lags} (24 by default)}

\item{lags}{(optional) integer, the number of lags to be included in the local projection model. Should not exceed \code{T_}-\code{hmax}(12 by default)}

\item{alphas}{(optional) vector of significance levels (0.05 by default)}

\item{init_partial}{(optional) bool, true if the parameter of interest should NOT be penalized (true by default)}

\item{selection}{(optional) integer, how should lambda be selected in BOTH the initial and nodewise regressions, 1=BIC, 2=AIC, 3=EBIC, 4=PI (4 by default)}

\item{PIconstant}{(optional) constant, used in the plug-in selection method (0.8 by default). For details see \insertCite{adamek2020lasso;textual}{desla}}

\item{progress_bar}{(optional) boolean, true if a progress bar should be displayed during execution (true by default)}
}
\value{
Returns a list with the following elements: \cr
\item{\code{intervals}}{matrix containing the point estimates and confidence intervals for the impulse response function, for significance levels given in \code{alphas}}
\item{\code{Thetahat}}{matrix (row vector) calculated from the nodewise regression at horizon 0, which is re-used at later horizons}
}
\description{
Calculates impulse responses with local projections, using the desla function to estimate the high-dimensional linear models, and provide asymptotic inference. The naming conventions in this function follow the notation in \insertCite{plagborg2021local;textual}{desla}, in particular Equation 1 therein.
}
\examples{
X<-matrix(rnorm(100*100), nrow=100)
y<-X[,1:4] \%*\% c(1, 2, 3, 4) + rnorm(100)
h<-HDLP(x=X[,4], y=y, q=X[,-4], hmax=5, lags=1)
}
\references{
\insertAllCited{}
}
