% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hA_calc.R
\name{hA_calc}
\alias{hA_calc}
\title{Calculation of Theoretically Optimal Bandwidth and Its Components}
\usage{
hA_calc(
  m,
  arma = list(ar = NULL, ma = NULL, sd_e = 1),
  p = c(1, 3),
  mu = c(0, 1, 2, 3),
  frequ = c(4, 12),
  n = 300,
  cb = 0.1
)
}
\arguments{
\item{m}{an expression that defines the trend function in terms of \code{x},
where \code{x} is the rescaled time on the interval \eqn{[0,1]}.}

\item{arma}{a list with the elements \code{ar}, \code{ma} and \code{sd_e};
\code{ar} is a numeric vector with the AR-coefficients, \code{ma} is a numeric 
vector with the MA-coefficients and \code{sd_e} is the innovation standard 
deviation.}

\item{p}{the order of polynomial to use locally for the trend estimation.}

\item{mu}{the smoothness parameter of the second-order kernel function used 
in the weighting process.}

\item{frequ}{the frequency of the theoretical time series (4 for quarterly and
12 for monthly time series).}

\item{n}{the number of observations.}

\item{cb}{the part of observations to drop at each boundary.}
}
\value{
This function returns a list with various elements. See the documentation of 
\code{\link{deseats}} to understand, what each quantity signifies.
\describe{
\item{\code{b}}{This is the theoretical quantity \eqn{\beta_{(k)}}.}
\item{\code{hA}}{The theoretically asymptotically optimal global bandwidth for 
locally weighted regression applied to the theoretical time series under 
consideration.}
\item{\code{Imk}}{This is the theoretical quantity \eqn{I[m^{(k)}]}.}
\item{\code{RK}}{This is the theoretical quantity \eqn{R(K)}.}
\item{\code{RW}}{This is the theoretical quantity \eqn{R(W)}.}
\item{\code{sum_autocov}}{This is the theoretical quantity \eqn{2\pi c_f}.}
}
}
\description{
Allows to calculate the theoretically optimal bandwidth for estimating
the trend and the seasonality in an equidistant time series with short-range 
dependence using locally weighted regression, if the trend function 
and the exact ARMA dependence structure of the errors are known.
}
\details{
For simulation studies of the function \code{\link{deseats}} one may be 
interested in obtaining the theoretically optimal bandwidth for local 
regression first for a given theoretical process (from which realizations 
will be drawn in the simulation). This function assists in obtaining this 
theoretical bandwidth.
}
\examples{
\donttest{
arma <- list(ar = 0.8, sd_e = 0.01)
m_f <- expression(13.1 + 3.1 * x + (dnorm(x / 0.15 - 0.5 / 0.15) / 0.15) / 4)
n <- 500
p <- 1
mu <- 1
frequ <- 4
cb <- 0.05

hA_calc(
 m = m_f,
 arma = arma, 
 p = p,
 mu = mu,
 frequ = frequ,
 n = n,
 cb = cb
)

t <- 1:n
xt <- t / n
mxt <- 13.1 + 3.1 * xt + dnorm(xt, mean = 0.5, sd = 0.15) / 4

S2 <- rep(c(0, 1, 0, 0), length.out = n)
S3 <- rep(c(0, 0, 1, 0), length.out = n)
S4 <- rep(c(0, 0, 0, 1), length.out = n)
sxt <- -0.5 + 0.25 * S2 + 0.5 * S3 + 1.25 * S4

set.seed(123)
et <- arima.sim(model = list(ar = 0.8), sd = 0.01, n = n)
yt <- ts(mxt + sxt + et, frequency = frequ)
plot(yt)

est <- deseats(yt)
est@bwidth
est@sum_autocov
}

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
