% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumps.R
\name{jumps}
\alias{jumps}
\alias{cashjump}
\alias{assetjump}
\alias{mertonjump}
\title{Option pricing with jumps}
\usage{
assetjump(s, k, v, r, tt, d, lambda, alphaj, vj, complete)
cashjump(s, k, v, r, tt, d, lambda, alphaj, vj, complete)
mertonjump(s, k, v, r, tt, d, lambda, alphaj, vj, complete)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{lambda}{Poisson intensity: expected number of jumps per year}

\item{alphaj}{Mean change in log price conditional on a jump}

\item{vj}{Standard deviation of change in log price conditional on
a jump}

\item{complete}{Return inputs along with prices, all in a data frame}
}
\value{
A vector of call and put prices computed using the Merton
    lognormal jump formula.
}
\description{
The functions \code{cashjump}, \code{assetjump}, and
    \code{mertonjump} return call and put prices, as vectors named
    "Call" and "Put", or "Call1", "Call2", etc. in case inputs are
    vectors. The pricing model is the Merton jump model, in which
    jumps are lognormally distributed.
}
\details{
Returns a scalar or vector of option prices, depending on
the inputs
}
\examples{
s <- 40; k <- 40; v <- 0.30; r <- 0.08; tt <- 2; d <- 0;
lambda <- 0.75; alphaj <- -0.05; vj <- .35;
bscall(s, k, v, r, tt, d)
bsput(s, k, v, r, tt, d)
mertonjump(s, k, v, r, tt, d, 0, 0, 0)
mertonjump(s, k, v, r, tt, d, lambda, alphaj, vj)

## following returns the same price as previous
c(1, -1)*(assetjump(s, k, v, r, tt, d, lambda, alphaj, vj) -
k*cashjump(s, k, v, r, tt, d, lambda, alphaj, vj))

## return call prices for different strikes
kseq <- 35:45
cp <- mertonjump(s, kseq, v, r, tt, d, lambda, alphaj,
    vj)$Call

## Implied volatilities: Compute Black-Scholes implied volatilities
## for options priced using the Merton jump model
vimp <- sapply(1:length(kseq), function(i) bscallimpvol(s, kseq[i],
    r, tt, d, cp[i]))
plot(kseq, vimp, main='Implied volatilities', xlab='Strike',
    ylab='Implied volatility', ylim=c(0.30, 0.50))
}
\seealso{
McDonald, Robert L., \emph{Derivatives Markets}, 3rd Edition
    (2013) Chapter 24

bscall bsput
}
