% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asianmontecarlo.R
\name{arithavgpricecv}
\alias{arithavgpricecv}
\title{Control variate asian call price}
\usage{
arithavgpricecv(s, k, v, r, tt, d, m, numsim)
}
\arguments{
\item{s}{Price of underlying asset}

\item{k}{Strike price of the option. In the case of average strike
options, \code{k/s} is the multiplier for the average}

\item{v}{Volatility of the underlygin asset price, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{numsim}{Number of Monte Carlo iterations}
}
\value{
Vector of the price of an arithmetic-average Asian call,
    computed using a control variate Monte Carlo calculation, along
    with the regression beta used for adjusting the price.
}
\description{
Calculation of arithmetic-average Asian call price
    using control variate Monte Carlo valuation
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; m=3; numsim=1e04
arithavgpricecv(s, k, v, r, tt, d, m, numsim)
}
\seealso{
Other Asian: \code{\link{arithasianmc}},
  \code{\link{asiangeomavg}}, \code{\link{geomasianmc}}
}
\concept{Asian}
