% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopulaBasedCoxPH_pseudoLikelihoodFunctions.R
\name{SolveL}
\alias{SolveL}
\title{Cumulative hazard function of survival time under dependent censoring}
\usage{
SolveL(
  theta,
  resData,
  X,
  W,
  cop = c("Frank", "Gumbel", "Normal"),
  dist = c("Weibull", "lognormal")
)
}
\arguments{
\item{theta}{Estimated parameter values/initial values for finite dimensional parameters}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T}

\item{W}{Data matrix with covariates related to C. First column of W should be ones}

\item{cop}{Which copula should be computed to account for dependency between T and C. This argument can take
one of the values from \code{c("Gumbel", "Frank", "Normal")}. The default copula model is "Frank".}

\item{dist}{The distribution to  be used for the dependent censoring C. Only two distributions are allowed, i.e, Weibull
and lognormal distributions. With the value \code{"Weibull"} as the
  default.}
}
\value{
This function returns an estimated hazard function, cumulative hazard function and distinct observed survival times;
}
\description{
This function estimates the cumulative hazard function of survival time (T) under dependent censoring (C). The estimation
makes use of the estimating equations derived based on martingale ideas.
}
\examples{
\donttest{
n = 200
beta = c(0.5)
lambd = 0.35
eta = c(0.9,0.4)
X = cbind(rbinom(n,1,0.5))
W = cbind(rep(1,n),rbinom(n,1,0.5))
frank.cop <- copula::frankCopula(param = 5,dim = 2)
U = copula::rCopula(n,frank.cop)
T1 = (-log(1-U[,1]))/(lambd*exp(X*beta))         # Survival time'
T2 = (-log(1-U[,2]))^(1.1)*exp(W\%*\%eta)          # Censoring time
A = runif(n,0,15)                                # administrative censoring time
Z = pmin(T1,T2,A)
d1 = as.numeric(Z==T1)
d2 = as.numeric(Z==T2)
resData = data.frame("Z" = Z,"d1" = d1, "d2" = d2)
theta = c(0.3,1,0.3,1,2)

# Estimate cumulative hazard function
cumFit <- SolveL(theta, resData,X,W)
cumhaz = cumFit$cumhaz
time = cumFit$times

# plot hazard vs time

plot(time, cumhaz, type = "l",xlab = "Time",
ylab = "Estimated cumulative hazard function")

}

}
