% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{G.hat}
\alias{G.hat}
\title{Compute the Gn matrix in step 3b of Bei (2024).}
\usage{
G.hat(
  data,
  beta,
  t,
  hp,
  mi.mat = NULL,
  m.avg = NULL,
  dm.avg = NULL,
  dmi.tens = NULL,
  D = NULL
)
}
\arguments{
\item{data}{Data frame.}

\item{beta}{Vector of coefficients.}

\item{t}{Time point at which to evaluate the (derivatives of) the moment
functions.}

\item{hp}{List of hyperparamerers.}

\item{mi.mat}{A precomputed matrix of moment function evaluations at each
observation. If supplied, some computations can be skipped. Default is
\code{mi.mat = NULL}.}

\item{m.avg}{A precomputed vector of the sample average of the moment
functions. If not supplied, this vector is computed. Default is
\code{m.avg = NULL}.}

\item{dm.avg}{Matrix of precomputed sample averages of the derivatives of the
moment functions. Default is \code{dm.avg = NULL}.}

\item{dmi.tens}{3D tensor of precomputed evaluations of the derivatives of
the moment functions. Default is \code{dmi.tens = NULL}.}

\item{D}{Diagonal of D-matrix.}
}
\value{
A matrix containing the partial derivatives of the variances of the
moment functions. Each row corresponds to a moment function, each column
corresponds to a covariate.
}
\description{
Compute the Gn matrix in step 3b of Bei (2024).
}
\references{
Bei, X. (2024). Local linearieation based subvector inference in
moment inequality models. Journal of Econometrics. 238:105549-
}
