% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullyParametricCopulas.R
\name{ParamCop}
\alias{ParamCop}
\title{Estimation of  a parametric dependent censoring model without covariates.}
\usage{
ParamCop(Y, Delta, Copula, Dist.T, Dist.C)
}
\arguments{
\item{Y}{Follow-up time.}

\item{Delta}{Censoring indicator.}

\item{Copula}{The copula family. This argument can take values from \code{c("frank","gumbel","clayton","gaussian","indep")}.}

\item{Dist.T}{The distribution to  be used for the survival time T. This argument can take one of the values from \code{c("lnorm", "weibull", "llogis")}.}

\item{Dist.C}{The distribution to  be used for the censoring time C. This argument can take one of the values from \code{c("lnorm", "weibull", "llogis")}.}
}
\value{
A table containing the minimized negative log-likelihood using the independence copula model, the estimated parameter values for the model with the independence copula, the minimized negative log-likelihood using the specified copula model and the estimated parameter values for the model with the specified copula.
}
\description{
Note that it is not assumed that the association parameter of the copula function is known,
unlike most other papers in the literature. The details for implementing the methodology can be found in Czado and Van Keilegom (2023).
}
\examples{
tau = 0.75
Copula = "frank"
Dist.T = "weibull"
Dist.C = "lnorm"
par.T = c(2,1)
par.C = c(1,2)
n=1000

simdata<-TCsim(tau,Copula,Dist.T,Dist.C,par.T,par.C,n)

Y = simdata[[1]]
Delta = simdata[[2]]

ParamCop(Y,Delta,Copula,Dist.T,Dist.C)

}
\references{
Czado and Van Keilegom (2023). Dependent censoring based on parametric copulas. Biometrika, 110(3), 721-738.
}
