% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cal_node_limit}
\alias{cal_node_limit}
\title{Calculate the x coordinates given a branch of dendrogram}
\usage{
cal_node_limit(x1, x2, subtree, center)
}
\arguments{
\item{x1}{A x coordinate\code{x1}}

\item{x2}{Another x coordinate\code{x2}}

\item{subtree}{A dendrogram object.\code{subtree}}

\item{center}{A logical whether the dendrogram is centered.\code{center}}
}
\value{
output A list of parameters.
}
\description{
\code{cal_node_limit} is a code modified from plotNodeLimit()
to x coordinates of branches given a branch of dendrogram.
}
\examples{
#generate sample data
set.seed(1234); par(mar=c(0,0,0,0))
x <- rnorm(10, mean=rep(1:5, each=2), sd=0.4)
y <- rnorm(10, mean=rep(c(1,2), each=5), sd=0.4)
dataFrame <- data.frame(x=x, y=y, row.names=c(1:10))
#calculate Euclidian distance
distxy <- dist(dataFrame)
#hierachical clustering "complete" linkage by default
hc <- hclust(distxy)

total <- cal_total_length(as.dendrogram(hc))
}
\keyword{internal}

