/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mgf;

import ch.fgcz.proteomics.dto.MassSpecMeasure;
import ch.fgcz.proteomics.dto.MassSpecMeasureSerializer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadMGF {
    private static final Logger LOGGER = Logger.getLogger(MassSpecMeasureSerializer.class.getName());

    private ReadMGF() {
        throw new IllegalStateException("Reader (mgf) class");
    }

    public static MassSpecMeasure read(String fileName) {
        String source = ReadMGF.readHeader(fileName);
        if (source == null) {
            source = fileName;
        }
        MassSpecMeasure massSpectrometryMeasurement = new MassSpecMeasure(source);
        ReadMGF.readLocal(fileName, massSpectrometryMeasurement);
        return massSpectrometryMeasurement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readHeader(String fileName) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
            String line = "";
            String[] partEqual = line.split("=");
            do {
                if ((line = bufferedReader.readLine()) == null) return null;
                if (!line.equals("BEGIN IONS")) continue;
                return null;
            } while (!line.contains("COM"));
            String string = partEqual[1];
            return string;
        }
        catch (FileNotFoundException e1) {
            LOGGER.log(Level.SEVERE, e1.toString(), e1);
            return null;
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, e2.toString(), e2);
        }
        return null;
    }

    private static MassSpecMeasure readLocal(String fileName, MassSpecMeasure massSpectrometryMeasurement) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(fileName));){
            String line = "";
            int chargeState = 0;
            int id = 0;
            double peptidMass = 0.0;
            ArrayList<Double> mz = new ArrayList<Double>();
            ArrayList<Double> intensity = new ArrayList<Double>();
            while ((line = bufferedReader.readLine()) != null) {
                String[] partEqual = line.split("=");
                String[] partSpace = line.split(" ");
                if (line.equals("BEGIN IONS")) {
                    chargeState = 0;
                    id = massSpectrometryMeasurement.getMSlist().size();
                    peptidMass = 0.0;
                    mz = new ArrayList();
                    intensity = new ArrayList();
                    continue;
                }
                if (line.equals("END IONS")) {
                    massSpectrometryMeasurement.addMS(mz, intensity, peptidMass, chargeState, id);
                    continue;
                }
                if (line.contains("CHARGE")) {
                    chargeState = Integer.parseInt(partEqual[1].substring(0, 1));
                    continue;
                }
                if (line.contains("PEPMASS")) {
                    String[] peptidMassSplit = partEqual[1].split(" ");
                    peptidMass = Double.parseDouble(peptidMassSplit[0]);
                    continue;
                }
                if (!ReadMGF.isDouble(partSpace[0]) || !ReadMGF.isDouble(partSpace[1])) continue;
                mz.add(Double.parseDouble(partSpace[0]));
                intensity.add(Double.parseDouble(partSpace[1]));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        return massSpectrometryMeasurement;
    }

    private static boolean isDouble(String string) {
        Scanner scanner = new Scanner(string);
        boolean b = scanner.hasNextDouble();
        scanner.close();
        return b;
    }
}

