/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.dto.MassSpectrum;
import ch.fgcz.proteomics.fbdm.Peak;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PeakList {
    private List<Peak> peakList = new ArrayList<Peak>();

    public boolean isEmpty() {
        return this.peakList.isEmpty();
    }

    public List<Peak> getPeakList() {
        return this.peakList;
    }

    public PeakList() {
        this.peakList = new ArrayList<Peak>();
    }

    public void add(Peak peak) {
        this.peakList.add(peak);
    }

    public Peak get(int i) {
        return this.peakList.get(i);
    }

    public void addAll(List<Peak> peakList) {
        this.peakList.addAll(peakList);
    }

    public int size() {
        return this.peakList.size();
    }

    public PeakList(MassSpectrum massSpectrum) {
        ArrayList<Peak> plist = new ArrayList<Peak>();
        for (int i = 0; i < massSpectrum.getMz().size() || i < massSpectrum.getIntensity().size(); ++i) {
            plist.add(new Peak(massSpectrum.getMz().get(i), massSpectrum.getIntensity().get(i), i));
        }
        this.peakList = plist;
    }

    public PeakList(List<Double> mz, List<Double> intensity) {
        ArrayList<Peak> plist = new ArrayList<Peak>();
        for (int i = 0; i < mz.size() || i < intensity.size(); ++i) {
            plist.add(new Peak(mz.get(i), intensity.get(i), i));
        }
        this.peakList = plist;
    }

    public PeakList mergePeakLists(PeakList peakList2) {
        PeakList notInIsotopicSet = new PeakList();
        for (Peak peak : this.peakList) {
            if (peak.isInSet()) continue;
            notInIsotopicSet.add(peak);
        }
        notInIsotopicSet.addAll(peakList2.getPeakList());
        return notInIsotopicSet;
    }

    public MassSpectrum makeResultSpectrum(MassSpectrum massSpectrum) {
        ArrayList<Double> mz = new ArrayList<Double>();
        ArrayList<Double> intensity = new ArrayList<Double>();
        ArrayList<Double> isotope = new ArrayList<Double>();
        ArrayList<Integer> charge = new ArrayList<Integer>();
        for (int i = 0; i < this.peakList.size(); ++i) {
            mz.add(this.peakList.get(i).getMz());
            intensity.add(this.peakList.get(i).getIntensity());
            isotope.add(this.peakList.get(i).getIsotope());
            charge.add(this.peakList.get(i).getCharge());
        }
        return new MassSpectrum(massSpectrum.getTyp(), massSpectrum.getSearchEngine(), mz, intensity, massSpectrum.getPeptideMass(), massSpectrum.getRt(), massSpectrum.getChargeState(), massSpectrum.getId(), charge, isotope);
    }

    public PeakList dechargePeaks(double H_MASS) {
        PeakList peaklistDecharged = new PeakList();
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (this.peakList.get(i).getCharge() > 1) {
                peaklistDecharged.getPeakList().add(new Peak(this.peakList.get(i).getMz() * (double)this.peakList.get(i).getCharge() - (double)(this.peakList.get(i).getCharge() - 1) * H_MASS, this.peakList.get(i).getIntensity(), this.peakList.get(i).getIsotope(), 1, this.peakList.get(i).getPeakID(), this.peakList.get(i).getIsotopicClusterID(), this.peakList.get(i).getIsotopicSetID()));
                continue;
            }
            peaklistDecharged.getPeakList().add(new Peak(this.peakList.get(i).getMz(), this.peakList.get(i).getIntensity(), this.peakList.get(i).getIsotope(), this.peakList.get(i).getCharge(), this.peakList.get(i).getPeakID(), this.peakList.get(i).getIsotopicClusterID(), this.peakList.get(i).getIsotopicSetID()));
        }
        return peaklistDecharged;
    }

    public PeakList filterNoisePeaks(double noise) {
        ArrayList<Double> intensity = new ArrayList<Double>();
        for (Peak peak : this.peakList) {
            intensity.add(peak.getIntensity());
        }
        double threshold = (Double)Collections.max(intensity) * noise / 100.0;
        PeakList peaklistNoise = new PeakList();
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (!(threshold < this.peakList.get(i).getIntensity())) continue;
            peaklistNoise.getPeakList().add(this.peakList.get(i));
        }
        return peaklistNoise;
    }

    public String saveAnnotatedSpectrum() {
        StringBuilder stringBuilder = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        stringBuilder.append("IsotopicSet,IsotopicCluster,Peak,Charge,mZ,Intensity").append(lineSep);
        for (Peak peak : this.peakList) {
            stringBuilder.append(peak.getIsotopicSetID()).append(",").append(peak.getIsotopicClusterID()).append(",").append(peak.getPeakID()).append(",").append(peak.getCharge()).append(",").append(peak.getMz()).append(",").append(peak.getIntensity()).append(lineSep);
        }
        return stringBuilder.toString();
    }

    public PeakList sortPeakList() {
        Collections.sort(this.peakList, new Comparator<Peak>(){

            @Override
            public int compare(Peak peakOne, Peak peakTwo) {
                return Double.compare(peakOne.getMz(), peakTwo.getMz());
            }
        });
        return this;
    }
}

