% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepboost.R
\name{deepboost.train}
\alias{deepboost.train}
\title{Trains a deepboost model}
\usage{
deepboost.train(object, data, tree_depth, num_iter, beta, lambda, loss_type,
  verbose, classes)
}
\arguments{
\item{object}{A Deepboost S4 class object}

\item{data}{input data.frame as training for model}

\item{tree_depth}{maximum depth for a single decision tree in the model}

\item{num_iter}{number of iterations = number of trees in ensemble}

\item{beta}{regularisation for scores (L1)}

\item{lambda}{regularisation for tree depth}

\item{loss_type}{- "l" logistic, "e" exponential}

\item{verbose}{- print extra data while training TRUE / FALSE}

\item{classes}{a vector of factors representing the classes used for classification with this model}
}
\value{
A trained Deepbost model
}
\description{
Trains a deepboost model
}
\details{
(beta,lambda) = (0,0) - adaboost, (>0,0) - L1, (0,>0) deepboost, (>0, >0) deepbost+L1
}
