% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubble_clust.R
\name{bubble_clust}
\alias{bubble_clust}
\title{Bubble plot}
\usage{
bubble_clust(
  x,
  clusters,
  bubble_size = 1,
  bubble_col = c("red", "white"),
  cex_text = 1,
  main = NULL
)
}
\arguments{
\item{x}{Document-term matrix describing the frequency of terms that occur in a collection of documents. Rows correspond to documents in the collection and columns correspond to terms.}

\item{clusters}{Integer vector of length of the number of cases, which indicates a clustering. The clusters have to be numbered from 1 to the number of clusters.}

\item{bubble_size}{Graphical parameter for bubbles size.}

\item{bubble_col}{Choose palette with two colors (default \code{"red"} and \code{"white"}).  The first (darker) color will denote homogeneous clusters, while the latter (lighter) more heterogeneous ones.}

\item{cex_text}{Size of texts inside bubbles.}

\item{main}{A title for the plot.}
}
\value{
A graphical aid to visualize and to describe the obtained clusters.
}
\description{
Bi-dimensional representation (via Multi-Dimensional Scaling) of the clusters, where each bubble corresponds to a cluster,
its size is proportional to the relative frequency of documents and color saturation reflects cluster cohesion.
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering
mou_CNAE2 = mou_EM(x = CNAE2, k = 2)

# Usage of the function
bubble_clust(mou_CNAE2$x,mou_CNAE2$clusters, bubble_size = 5 )

}
