% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompr.R
\docType{data}
\name{leather}
\alias{leather}
\title{Leather Example ICIO Data}
\format{
A list of class 'iot' with the following elements:
\describe{
 \item{\code{inter}}{9 x 9 input output matrix where each column gives the value of inputs supplied to the corresponding country-industry by each row country-industry.}
 \item{\code{final}}{9 x 3 final demand matrix showing the final demand in each country (column) for each country-industry's (rows) produce.}
 \item{\code{countries}}{character vector of country names (matching columns of \code{final}).}
 \item{\code{industries}}{character vector of industries, such that \code{as.vector(t(outer(countries, industries, FUN = paste, sep = ".")))} generates the row- and column-names of \code{inter} and the rownames of \code{final}.}
 \item{\code{out}}{A vector of gross country-industry output. In a complete productive system it should be equal to \code{rowSums(inter) + rowSums(final)}.}
}
}
\usage{
data("leather")
}
\description{
An example 3 x 3 ICIO table describing a GVC for leather products with industries 'Agriculture', 'Textile and Leather' and 'Transport Equipment'
for the countries 'Argentina', 'Turkey' and 'Germany'.
}
\seealso{
\code{\link{decompr-package}}
}
