% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vv.R
\name{vv}
\alias{vv}
\title{value varier function}
\usage{
vv(var_mean, var_CV, n, distribution = "normal", absolute_trend = NA,
  relative_trend = NA, lower_limit = NA, upper_limit = NA)
}
\arguments{
\item{var_mean}{mean of the variable to be varied}

\item{var_CV}{desired coefficient of variation (in percent)}

\item{n}{integer; number of values to produce}

\item{distribution}{probability distribution for the introducing variation.
Currently only implemented for "normal"}

\item{absolute_trend}{absolute increment in the var_mean in each time step.
Defaults to NA, which means no such absolute value trend is present. If both
absolute and relative trends are specified, only original means are used}

\item{relative_trend}{relative trend in the var_mean in each time step (in
percent). Defaults to NA, which means no such relative value trend is
present. If both absolute and relative trends are specified, only original
means are used}

\item{lower_limit}{lowest possible value for elements of the resulting vector}

\item{upper_limit}{upper possible value for elements of the resulting vector}
}
\value{
vector of n numeric values, representing a variable time series,
which initially has the mean var_mean, and then increases according to the
specified trends. Variation is determined by the given coefficient of
variation var_CV
}
\description{
Many variables vary over time and it may not be desirable to ignore this
variation in time series analyses. This function produces time series that
contain variation from a specified mean and a desired coefficient of
variation. A trend can be added to this time series
}
\details{
Note that only one type of trend can be specified. If neither of the trend
parameters are NA, the function uses only the original means
}
\examples{

valvar<-vv(100,10,30)
plot(valvar)

valvar<-vv(100,10,30,absolute_trend=5)
plot(valvar)

valvar<-vv(100,10,30,relative_trend=5)
plot(valvar)

}
\author{
Eike Luedeling
}
\keyword{~kwd1}
\keyword{~kwd2}
