% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-calculate_neg_freq.R
\name{calculate_negative_freqs}
\alias{calculate_negative_freqs}
\title{Calculate negative frequencies in whole plate}
\usage{
calculate_negative_freqs(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\description{
The resulting plate has the same droplet data but an updated metadata with
the number of negative/positive droplets and the negative frequency.
}
\examples{
file <- system.file("sample_data", "small", "analyzed_pnpp.rds", package = "ddpcr")
plate <- load_plate(file)
plate \%>\% calculate_negative_freqs \%>\%
  well_info(wells_success(plate), "negative_freq")
}
\seealso{
\code{\link[ddpcr]{pnpp_experiment}}
}
\keyword{internal}
