% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/duke_predict.R
\name{duke_predict}
\alias{duke_predict}
\title{Predict using deployed model using REST API.}
\usage{
duke_predict(auth_details, model_name, new_data, host_name = NULL)
}
\arguments{
\item{auth_details}{authorization parameters (must be stored in list format: list(user_name='exampleusername',api_key='exampleapikey'))}

\item{model_name}{the name of the deployed model for predictions.}

\item{new_data}{new feature values for predictions.}

\item{host_name}{optional parameter.}
}
\value{
On successful prediction, a character vector with model predictions. An error message is returned on failure.
}
\description{
Predict using deployed model using REST API.
}
\examples{
duke_auth <- list(
user_name = "try_it",
api_key   = "db1542b66f16aba5768d8a19c27dec4facf9168a",
endpoint = "/api/v1.0"
)
example_data <- as.data.frame(cbind(gl(3,50),rnorm(150)));names(example_data) <- c("x","y")
duke_predict(auth_details=duke_auth,model_name="example_fit",example_data)
}
\seealso{
\code{\link{duke_deploy}} for deploying a model or \code{\link{duke_list}} to display a list of all deployed models.
}

