% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-summarise.R
\name{summarise.tbl_lazy}
\alias{summarise.tbl_lazy}
\title{Summarise each group to one row}
\usage{
\method{summarise}{tbl_lazy}(.data, ...)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables, or functions or
variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending order.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the dplyr \code{\link[=summarise]{summarise()}} generic. It generates the
\code{SELECT} clause of the SQL query, and generally needs to be combined with
\code{group_by()}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(g = c(1, 1, 1, 2, 2), x = c(4, 3, 6, 9, 2))
db \%>\%
  summarise(n()) \%>\%
  show_query()

db \%>\%
  group_by(g) \%>\%
  summarise(n()) \%>\%
  show_query()
}
