% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_clean.R
\name{clean_wq}
\alias{clean_wq}
\alias{cleanwq}
\title{Clean raw water quality DBHYDRO data retrievals}
\usage{
clean_wq(dt, raw = FALSE, mdl_handling = "raw")
}
\arguments{
\item{dt}{data.frame output of \code{\link{getwq}}}

\item{raw}{logical default is FALSE, set to TRUE to return data in "long"
format with all comments, qa information, and database codes included}

\item{mdl_handling}{character string specifying the handling of measurement
values below the minimum detection limit (MDL). Example choices for this
argument include:
\itemize{
\item \code{raw}: Returns values exactly as they are stored in the database.
Current practice is to return values below the MDL as 0 minus the uncertainty
estimate.
\item \code{half}: Returns values below the MDL as half the MDL
\item \code{full}: Returns values below the MDL as the MDL
}}
}
\description{
Removes extra columns associated with QA flags and QA blanks
which are used to check on potential sources of contamination. If raw is set
to TRUE, \code{\link{get_wq}} results are converted from long (each piece of
data on its own row) to \code{wide} format (each site x variable combination
in its own column).
}
\examples{
\dontrun{
#check handling of values below MDL
dt <- getwq("FLAB01", "2014-09-14", "2014-09-18", "NITRATE+NITRITE-N",
 raw = TRUE)
clean_wq(dt, mdl_handling = "raw")
clean_wq(dt, mdl_handling = "half")
}

dt <- read.csv(system.file("extdata", "testwq.csv", package = "dbhydroR"))
clean_wq(dt)
}
