% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_add_dates.R
\name{missing_taxa_check}
\alias{missing_taxa_check}
\title{Checks that missing_taxa argument is ok to be used by make_mrbayes_runfile inside tree_add_dates functions.}
\usage{
missing_taxa_check(missing_taxa = NULL, dated_tree = NULL)
}
\arguments{
\item{missing_taxa}{A tree, a data frame or a vector enlisting all missing taxa you want to include.
\describe{
\item{A tree}{Either as a phylo object or as a newick character string.
It contains all taxa that you want at the end, both missing and non missing.
This tree will be used as a hard constraint.}
\item{A \code{data.frame}}{It contains two columns named "taxon" and "clade".
The first one contains a character vector of missing taxon names.
The second one contains a character or numeric vector of nodes from a
constraint tree to which each taxon will be assigned.}
\item{A character vector}{It contains the names of the missing taxa.
They will be added at random to the constraint tree.}
}}

\item{dated_tree}{a tree (newick or phylo) with branch lengths proportional to absolute time}
}
\value{
A phylo object, a newick character string or a dataframe with taxonomic assignations
}
\description{
Checks that missing_taxa argument is ok to be used by make_mrbayes_runfile inside tree_add_dates functions.
}
