% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groves.R
\name{is_n_overlap}
\alias{is_n_overlap}
\title{Function for computing n-overlap for two vectors of names (ie., phy1$tip.label, phy2$tip.label) and seeing if they have n overlap}
\usage{
is_n_overlap(names_1, names_2, n = 2)
}
\arguments{
\item{names_1}{First vector of names}

\item{names_2}{Second vector of names}

\item{n}{Degree of overlap required}
}
\value{
Boolean for whether the degree of overlap was met or not.
}
\description{
This function implements definition 2.8 for n-overlap from Ané
et al. (2009) \doi{10.1007/s00026-009-0017-x}.
}
\references{
Ané, C., Eulenstein, O., Piaggio-Talice, R., & Sanderson, M. J. (2009).
"Groves of phylogenetic trees". Annals of Combinatorics, 13(2), 139-167,
\doi{10.1007/s00026-009-0017-x}.
}
