% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeg.R
\encoding{UTF-8}
\name{load_seeg}
\alias{load_seeg}
\title{Greenhouse gases emission estimates (SEEG)}
\usage{
load_seeg(dataset = NULL, raw_data, geo_level, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("seeg", seeg_farming", "seeg_industry", "seeg_energy", "seeg_land", "seeg_residuals"). On which "seeg" contains all five sectors (only works with raw_data = TRUE) and the others are filtered specifically by a main source of emission. See \url{http://seeg.eco.br/notas-metodologicas/}}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads data of estimates of emission of greenhouse gases
}
\examples{
\dontrun{
# download state raw data
seeg <- load_seeg(
  dataset = "seeg",
  raw_data = TRUE,
  geo_level = "state"
)

# download country energy treated data
seeg1 <- load_seeg(
  dataset = "seeg_energy",
  raw_data = FALSE,
  geo_level = "country"
)

# download land municipality treated data
seeg2 <- load_seeg(
  dataset = "seeg_land",
  raw_data = FALSE,
  geo_level = "municipality"
)
}
}
