% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comex.R
\encoding{UTF-8}
\name{load_br_trade}
\alias{load_br_trade}
\title{Comex - External Trade}
\usage{
load_br_trade(dataset = NULL, raw_data, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("comex_export_mun", "comex_import_mun", "comex_export_prod" or "comex_import_prod").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} consisting of imports or exports data.
}
\description{
Loads information on both imports and exports data. Data is available from 1997 to 2021 for most datasets. See \url{https://www.gov.br/produtividade-e-comercio-exterior/pt-br/assuntos/comercio-exterior/estatisticas/base-de-dados-bruta/}.
}
\examples{
\dontrun{
# download treated exports data by municipality from 1997 to 2021
exp_mun <- load_br_trade(
  dataset = "comex_export_mun",
  raw_data = FALSE, time_period = 1997:2021
)

# download raw imports data by municipality from 1997 to 2021
raw_imp_mun <- load_br_trade(
  dataset = "comex_import_mun",
  raw_data = TRUE, time_period = 1997:2021
)

# download treated imports data by ncm from 1997 to 2021
imp_prod <- load_br_trade(
  dataset = "comex_import_prod",
  raw_data = FALSE, time_period = 1997:2021
)
}

}
