% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictJobs.R
\name{GetPredictJob}
\alias{GetPredictJob}
\title{Request information about a predict job}
\usage{
GetPredictJob(project, predictJobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictJobId}{Character string specifying the job id}
}
\value{
list with following elements:
\describe{
  \item{status}{Prediction job status; an element of JobStatus, e.g. JobStatus$Queue}
  \item{predictJobId}{Character string specifying the job id}
  \item{modelId}{Character string specifying the model from which
  predictions have been requested}
  \item{projectId}{Character string specifying the project that contains the model}
}
}
\description{
Request information about a predict job
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetPredictJobs(project)
  job <- initialJobs[[1]]
  predictJobId <- job$predictJobId
  GetPredictJob(projectId, predictJobId)
}
}
