% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingPredictions.R
\name{GetTrainingPredictionsFromJobId}
\alias{GetTrainingPredictionsFromJobId}
\title{Retrieve the training predictions for a model using a job id.}
\usage{
GetTrainingPredictionsFromJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{integer. Unique integer identifier (return for example by
\code{RequestPredictionExplanations}).}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete.}
}
\value{
A dataframe with out-of-fold predictions for the training data.
}
\description{
Retrieve the training predictions for a model using a job id.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  jobId <- RequestTrainingPredictions(model, dataSubset = "all")
  trainingPredictions <- GetTrainingPredictionsFromJobId(projectId, jobId)
}
}
