% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{GetDeployment}
\alias{GetDeployment}
\title{Get information on a particular deployment.}
\usage{
GetDeployment(deploymentId)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}
}
\value{
A DataRobotDeployment object containing:
\itemize{
 \item id character. The ID of the deployment.
 \item label character. The label of the deployment.
 \item description character. The description of the deployment.
 \item defaultPredictionServer list. Information on the default prediction
   server connected with the deployment. See \code{ListPredictionServers}
   for details.
 \item model dataRobotModel. The model associated with the deployment.
   See \code{GetModel} for details.
 \item capabilities list. Information on the capabilities of the deployment.
 \item predictionUsage list. Information on the prediction usage of the deployment.
 \item serviceHealth list. Information on the service health of the deployment.
 \item modelHealth list. Information on the model health of the deployment.
 \item accuracyHealth list. Information on the accuracy health of the deployment.
}
}
\description{
Get information on a particular deployment.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  GetDeployment(deploymentId)
}
}
