% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferableModels.R
\name{DownloadTransferableModel}
\alias{DownloadTransferableModel}
\title{Download an transferable model file for use in an on-premise DataRobot standalone
prediction environment.}
\usage{
DownloadTransferableModel(project, modelId, modelFile)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. Unique alphanumeric identifier for the model of interest.}

\item{modelFile}{character. File name to be use for transferable model}
}
\description{
This function can only be used if model export is enabled, and will only be useful
if you have an on-premise environment in which to import it.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  file <- file.path(tempdir(), "model.drmodel")
  DownloadTransferableModel(projectId, modelId, file)
}
}
