% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jobs.R
\name{GetJob}
\alias{GetJob}
\title{Request information about a job}
\usage{
GetJob(project, jobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{Character string specifying the job id}
}
\value{
list with following elements:
\itemize{
  \item status character. Model job status; an element of \code{JobStatus}, e.g.
    \code{JobStatus$Queue}.
  \item url character. URL to request more detail about the job.
  \item id character. The job id.
  \item jobType character. See \code{JobType} for valid values.
  \item projectId character. The project that contains the model.
  \item isBlocked logical. If TRUE, the job is blocked (cannot be executed) until its
    dependencies are resolved.
}
}
\description{
Request information about a job
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- ListModelJobs(project)
  job <- initialJobs[[1]]
  jobId <- job$modelJobId
  GetJob(projectId, jobId)
}
}
