% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimeFiles.R
\name{GetPrimeFileFromJobId}
\alias{GetPrimeFileFromJobId}
\title{Retrieve a specific Prime file from a DataRobot project for corresponding jobId}
\usage{
GetPrimeFileFromJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{jobId}{numeric. Unique integer identifier (return for example by \code{RequestPrimeModel})}

\item{maxWait}{numeric. maximum time to wait (in sec) before job completed.}
}
\value{
List with following elements:
\describe{
  \item{language}{Character string. Code programming language}
  \item{isValid}{logical flag indicating if code passed validation}
  \item{rulesetId}{Integer identifier for the ruleset}
  \item{parentModelId}{Unique alphanumeric identifier for the parent model}
  \item{projectId}{Unique alphanumeric identifier for the project}
  \item{id}{Unique alphanumeric identifier for the Prime file}
  \item{modelId}{Unique alphanumeric identifier for the model}
}
}
\description{
Retrieve a specific Prime file from a DataRobot project for corresponding jobId
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetModelJobs(project)
  job <- initialJobs[[1]]
  modelJobId <- job$modelJobId
  GetPrimeFileFromJobId(projectId, modelJobId)
}
}
