% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc}
\alias{qc}
\title{Apply all tests}
\usage{
qc(Data, Metadata = NULL, outpath, time_offset = 0)
}
\arguments{
\item{Data}{Either a character vector of paths to SEF files, a data frame
or a list of data frames with 7 columns (one data frame for each station):
variable code, year, month, day, hour, minute, value.
Each data frame can contain more than one variable code.}

\item{Metadata}{A data frame with 7 columns: station ID, latitude, longitude,
altitude, variable code, units, resolution. If \code{Data} is a list, the station 
IDs must appear in the same order of the respective elements in the list.
'resolution' can be either 'daily' (or 'd') or 'subdaily' (or 's').
If \code{Data} is a vector, \code{Metadata} is ignored and all the
required information is read from the SEF files.}

\item{outpath}{Character string giving the path where the output is saved.}

\item{time_offset}{Numerical vector (of length 1 or equal to the number of 
analysed stations) of the number of hours to add to the time 
to obtain local time. This is used for tests on day and night temperature.
Recycled for all stations if only one value is given. Data not stored
in SEF files (i.e., not in UTC) are typically already expressed in local time:
in this case the offset is zero (the default).}
}
\description{
Perform all quality tests at once on multiple stations and multiple
variables.
}
\details{
This is a wrapper of all functions that can be applied to the variables given
in \code{Data} (except the plotting functions).

\code{Data} can include any supported variable (see \link{Variables}) from 
different stations. The algorithm
will select the tests that can be applied to each variable. Note that some
tests require more than one variable from the same station.

This function produces flag files (one for each variable at each
station). The filenames follow the standard 
'qc_<stationID>_<varcode>_<resolution>.txt'.
Each files contains a table of flagged values, with the last column
indicating the tests failed by each flagged observation.

The flag files can be edited by hand to remove or add flags. The flags can 
then be added to the 'Meta' column of SEF files by using the function 
\link{write_flags}.
}
\note{
The tests will use their default parameters (e.g. thresholds). To use
custum parameters run the tests one by one.
}
\examples{
# Testing all variables for Rosario de Santa Fe

# Create a data frame with all data from list Rosario
# For daily data we need to add the hour and minute columns (NAs)
Ros <- Rosario
Ros$Tx[,c("Hour","Minute")] <- NA
Ros$Tn[,c("Hour","Minute")] <- NA
Ros$rr[,c("Hour","Minute")] <- NA
Ros <- do.call("rbind", Ros)
Ros <- Ros[, c("Var","Year","Month","Day","Hour","Minute","Value")]

# Create a data frame with metadata including data resolution
df_meta <- do.call("rbind", Meta)
df_meta <- df_meta[which(df_meta$id=="Rosario"), ]
df_meta$res <- c("s", "s", "d", "d", "s", "s", "d", rep("s",4))

# Run all qc tests at once
# Time for Rosario is in UTC, therefore an offset is needed to get local time 
qc(Ros, df_meta, outpath = tempdir(), time_offset=-4.28)


# Testing one variable at one station
qc(Bern$ta, cbind(Meta$ta[which(Meta$ta$id=="Bern"),],"s"), 
   outpath = tempdir(), time_offset=0)
   
}
\author{
Yuri Brugnara
}
