% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unibern.R
\name{duplicate_columns}
\alias{duplicate_columns}
\title{Duplicate columns test}
\usage{
duplicate_columns(Data, meta = NULL, outpath, ndays = 5)
}
\arguments{
\item{Data}{A character string giving the path of the input file,
or a matrix with 5 (7) columns for daily (sub-daily) data: variable code, year, 
month, day, (hour), (minute), value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{Data} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{ndays}{Number of consecutive days with zero difference required to
flag the data. The default is 5.}
}
\description{
Looks for data that have been digitized twice by mistake. For sud-daily data,
this is done by looking for series of zero differences between adjacent
observation times. For daily data, by looking for series of zero differences 
between the same days of adjacent months.
}
\details{
The input file must follow the Copernicus Station Exchange 
Format (SEF). This function works with any numerical variable.

Zeroes are automatically excluded in bounded variables such as precipitation.
}
\examples{
climatic_outliers(Rosario$Tn, Meta$Tn, outpath = tempdir(), ndays = 3) 

}
\author{
Yuri Brugnara
}
