% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_data_report.R
\name{render_data_report}
\alias{render_data_report}
\title{Generate a fast data report}
\usage{
render_data_report(
  df_input,
  df_input_old = NULL,
  save_rmd_dir = NULL,
  save_report_dir = NULL,
  save_rmd_file = NULL,
  save_report_file = NULL,
  include_skim = TRUE,
  include_diffdf = TRUE,
  output_format = "html"
)
}
\arguments{
\item{df_input}{data.frame or tibble. Input dataset to generate the summary report on.}

\item{df_input_old}{data.frame or tibble. Old input dataset to call diffdf::diffdf() on.}

\item{save_rmd_dir}{character. Path to save the .Rmd file to. Defaults to the current
working directory. If NULL, does not save the report to disk.}

\item{save_report_dir}{character. Path to save the report to. Defaults to the current
working directory.}

\item{save_rmd_file}{character. Path to save the .Rmd file to. Can be either a
file name (e.g., "data_report") or a file path. If a file path is specified,
it must be consistent with save_rmd_dir, if save_rmd_dir is specified. If
there is no file extension in the file path, automatically appends the .Rmd
extension.}

\item{save_report_file}{character. Path to save the report to. Can be either a
file name (e.g., "data_report") or a file path. If a file path is specified,
it must be consistent with save_report_dir, if save_report_dir is specified. If
there is no file extension in the file path, automatically appends an extension.}

\item{include_skim}{boolean. TRUE to include the data summary with skimr::skim() in the
report. FALSE to exclude.}

\item{include_diffdf}{boolean. TRUE to include the data diff with diffdf::diffdf() in the report.
FALSE to exclude. If df_input_old is not specified, automatically set to FALSE.}

\item{output_format}{character. Output format of the data report. Defaults to "html." So far, only "pdf" and "html"
are supported.}
}
\value{
An output RMarkdown report with the data summary.
}
\description{
Generate a fast data report
}
\examples{
set.seed(12345)
iris = datasets::iris
iris_permuted = iris
iris_permuted$Species <- sample(iris$Species)
render_data_report(
  df_input = iris,
  df_input_old = iris_permuted,
  save_rmd_dir = tempdir(),
  save_report_dir = tempdir(),
  include_skim = TRUE,
  include_diffdf = TRUE
)
}
