% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_filter_missing_list_table_for_rv.R
\name{util_filter_missing_list_table_for_rv}
\alias{util_filter_missing_list_table_for_rv}
\title{Filter a \code{MISSING_LIST_TABLE} for rows matching the variable \code{rv}}
\usage{
util_filter_missing_list_table_for_rv(table, rv, rv2 = rv)
}
\arguments{
\item{table}{\link{cause_label_df} a data frame with missing codes and
optionally \code{resp_vars}. It also comprises
labels and optionally an interpretation
column with \code{AAPOR} codes. Must already cover
the variable \code{rv}, i.e., item level metadata
is not checked to find the suitable missing
table for \code{rv}.}

\item{rv}{\link{variable} the response variable to filter the missing list for
specified by a label.}

\item{rv2}{\link{variable} the response variable to filter the missing list for
specified by a \code{VAR_NAMES}-name.}
}
\value{
\link{data.frame} the row-wise bound data frames as one data frame
}
\description{
In \code{MISSING_LIST_TABLE}, a column \code{resp_vars} may be specified. If so,
and if, for a row, this column is not empty, then that row only affects the
one variable specified in that cell
}
\seealso{
Other missing_functions: 
\code{\link{util_all_intro_vars_for_rv}()},
\code{\link{util_count_expected_observations}()},
\code{\link{util_get_code_list}()},
\code{\link{util_is_na_0_empty_or_false}()},
\code{\link{util_observation_expected}()},
\code{\link{util_remove_empty_rows}()},
\code{\link{util_replace_codes_by_NA}()}
}
\concept{metadata_management}
\concept{missing_functions}
\keyword{internal}
