% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_clean_labels.R
\name{prep_clean_labels}
\alias{prep_clean_labels}
\title{Support function to scan variable labels for applicability}
\usage{
prep_clean_labels(label_col, meta_data = "item_level", no_dups = FALSE)
}
\arguments{
\item{label_col}{\link{character} label attribute to adjust or character vector to
adjust, depending on \code{meta_data} argument is
given or missing.}

\item{meta_data}{\link{data.frame} meta data frame: If \code{label_col} is a label
attribute to adjust, this is the meta data
table to process on. If missing, \code{label_col}
must be a character vector with values to
adjust.}

\item{no_dups}{\link{logical} disallow duplicates in input or output vectors of
the function, then, prep_clean_labels would call
\code{stop()} on duplicated labels.}
}
\value{
a data.frame with:
\itemize{
\item if \code{meta_data} is set, a list with:
\itemize{
\item modified \code{meta_data[, label_col]} column
}
\item if \code{meta_data} is not set, adjusted labels that then were directly given
in label_col
}
}
\description{
Adjust labels in meta_data to be valid variable names in formulas for
diverse r functions, such as \code{\link{glm}} or \code{\link[lme4:lmer]{lme4::lmer}}.
}
\details{
Currently, labels as given by \code{label_col} arguments in the most functions
are directly used in formula, so that they become natural part of the
outputs, but different models expect differently strict syntax for such
formulas, especially for valid variable names. \code{prep_clean_labels} removes
all potentially inadmissible characters from variable names (no guarantee,
that some exotic model still rejects the names, but minimizing the number
of exotic characters). However, variable names are modified, may become
unreadable or indistinguishable from other variable names. For the latter
case, a \code{stop} call is possible, controlled by the \code{no_dups} argument.

A warning is emitted, if modifications were necessary.
}
\examples{
\dontrun{
meta_data1 <- data.frame(
  LABEL =
    c(
      "syst. Blood pressure (mmHg) 1",
      "1st heart frequency in MHz",
      "body surface (\\\\u33A1)"
    )
)
print(meta_data1)
print(prep_clean_labels(meta_data1$LABEL))
meta_data1 <- prep_clean_labels("LABEL", meta_data1)
print(meta_data1)
}
}
