% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{removeMember}
\alias{removeMember}
\alias{removeMember,DataPackage-method}
\title{Remove the Specified Member from the Package}
\usage{
removeMember(x, ...)

\S4method{removeMember}{DataPackage}(x, do, removeRelationships = FALSE)
}
\arguments{
\item{x}{a DataPackage object}

\item{...}{(Not yet used)}

\item{do}{The package member to remove, either as a \code{"DataObject"} or \code{"character"} (for the object identifier)}

\item{removeRelationships}{A \code{logical} value. If TRUE, package relationships for this package member are removed. Default is FALSE.}
}
\description{
Given the identifier of a DataObject in a DataPackge, delete the DataObject
from the DataPackage.
}
\details{
The \code{removeMember} method removes the specified DataObject from the DataPackage. In 
addition, any package relationships that included the DataObject are removed.
}
\examples{
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do <- new("DataObject", id="myNewId", dataobj=data, format="text/csv", user="jsmith")
dp <- addMember(dp, do)
# Remove the package member and any provenance relationships that reference it.
removeMember(dp, "myNewId", removeRelationships=TRUE)
}
\seealso{
\code{\link{DataPackage-class}}
}
