% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{serializePackage}
\alias{serializePackage}
\alias{serializePackage,DataPackage-method}
\title{Create an OAI-ORE resource map from the package}
\usage{
serializePackage(x, ...)

\S4method{serializePackage}{DataPackage}(x, file, id = as.character(NA),
  syntaxName = "rdfxml", mimeType = "application/rdf+xml",
  namespaces = data.frame(namespace = character(), prefix = character(),
  stringsAsFactors = FALSE), syntaxURI = as.character(NA),
  resolveURI = as.character(NA))
}
\arguments{
\item{x}{A DataPackage object}

\item{...}{Additional arguments}

\item{file}{The file to which the ResourceMap will be serialized}

\item{id}{A unique identifier for the serialization. The default value is the id assinged 
to the DataPackage when it was created.}

\item{syntaxName}{The name of the syntax to use for serialization - default is "rdfxml"}

\item{mimeType}{The mimetype of the serialized output - the default is "application/rdf+xml"}

\item{namespaces}{A data frame containing one or more namespaces and their associated prefix}

\item{syntaxURI}{URI of the serialization syntax}

\item{resolveURI}{A character string containing a URI to prepend to datapackage identifiers}
}
\description{
The Datapackage is serialized as a OAI-ORE resource map to the specified file.
}
\details{
The resource map that is created is serialized by default as RDF/XML. Other serialization formats
can be specified using the \code{syntaxName} and \code{mimeType} parameters. Other available formats
include: 
\tabular{ll}{
\strong{syntaxName}\tab \strong{mimeType}\cr
json\tab application/json\cr
ntriples\tab application/n-triples\cr
turtle\tab text/turtle\cr
dot\tab text/x-graphviz\cr
} 
Note that the \code{syntaxName} and \code{mimeType} arguments together specify o serialization format.

Also, for packages that will be uploaded to the DataONE network, "rdfxml" is the only 
accepted format.  

The resolveURI string value is prepended to DataPackage member identifiers in the resulting resource map. 
If no resolveURI value is specified, then 'https://cn.dataone.org/cn/v1/resolve' is used.
}
\examples{
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do <- new("DataObject", id="do1", dataobj=data, format="text/csv", user="jsmith")
dp <- addData(dp, do)
data2 <- charToRaw("7,8,9\\n4,10,11")
do2 <- new("DataObject", id="do2", dataobj=data2, format="text/csv", user="jsmith")
dp <- addData(dp, do2)
recordDerivation(dp, "do2", "do2")
status <- serializePackage(dp, file="/tmp/resmap.json", syntaxName="json", 
  mimeType="application/json")
status <- serializePackage(dp, file="/tmp/resmap.rdf", syntaxName="rdfxml", 
  mimeType="application/rdf+xml")
status <- serializePackage(dp, file="/tmp/resmap.ttl", syntaxName="turtle", 
  mimeType="text/turtle")
}
\seealso{
\code{\link{DataPackage-class}}
}

