% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{d1IdentifierSearch}
\alias{d1IdentifierSearch}
\alias{d1IdentifierSearch,D1Client-method}
\title{Query the DataONE Solr endpoint of the Coordinating Node.}
\usage{
d1IdentifierSearch(x, ...)

\S4method{d1IdentifierSearch}{D1Client}(x, solrQuery)
}
\arguments{
\item{x}{D1Client: representing the DataONE environment being queried}

\item{...}{Additional parameters}

\item{solrQuery}{character: a query string}
}
\value{
a vector of identifiers found
}
\description{
The DataONE CN Solr query engine is searched using
the provided query string.
}
\examples{
\dontrun{
library(dataone)
client <- new("D1Client")
result <- d1IdentifierSearch(client,solrQuery="species population diversity")
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}

