% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{treevolruca}
\alias{treevolruca}
\title{Contains tree-level variables of several species in the Rucamanque experimental forest, near Temuco, Chile.}
\format{
Contains tree-level variables, as follows:
\describe{
  \item{tree.no}{Tree id.}
\item{spp}{Species.}
\item{dbh}{Diameter at breast height, in cm.}
\item{htot}{Total height, in m.}
 \item{d6}{Upper-stem diameter at 6 m, in cm.}
\item{vtot}{Tree gross volume, in m^{3} with bark.}
 }
}
\source{
The data were provided courtesy of Dr Christian Salas (Universidad Mayor, Santiago, Chile).
}
\usage{
data(treevolruca)
}
\description{
These are tree-level measurement data of sample trees in the Rucamanque experimental forest, 
 near Temuco, in the Araucania region in south-centralChile, measured in 1999.  The following
 species are part of the data: laurel (laurelia sempervirens), lingue (Persea lingue), olivillo (Aextocicon puncatum), 
 roble (Nothofagus obliqua), tepa (Laureliosis philippiana), y tineo (Weinmannia trichosperma).
}
\examples{
data(treevolruca)    
head(treevolruca) 
}
\references{
Salas C. 2002. Ajuste y validacion de ecuaciones de volumen para un relicto
 del bosque de Roble-Laurel-Lingue [Fitness and validation of volume equations for a relict forest of Roble-Laurel-Lingue].
  Bosque 23(2): 81-92.
}
\keyword{datasets}
