% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{download_data}
\alias{download_data}
\title{Download files asociate with dataesgobr object}
\usage{
download_data(x, format, all = TRUE, position = 0, noconfirm = FALSE,
  overwrite = NULL, outfile = NULL)
}
\arguments{
\item{x}{A dataesgobr containing information and data from datos.gob.es}

\item{format}{A string, the data's format to download}

\item{all}{A logical, this parameter indicates if the function must download every file}

\item{position}{Numeric, the number in the format list}

\item{noconfirm}{Logical, this parameter indicates if the user must confirm
the downloads or no}

\item{overwrite}{A logical, if this parameter is TRUE then the downloaded file will replace
automatically the old file if it exists}

\item{outfile}{A string, the user can indicates the path to save the file}
}
\description{
This function downloads the data associated with the dataset
passed like param from datos.gob.es
}
\examples{
library(dataesgobr)
\donttest{
id <- "l01280066-horarios-de-metro1"
dataset <- search_by_id(id)
download_data(dataset, "text/csv", noconfirm = TRUE, outfile = tempdir())
download_data(dataset, "text/csv", noconfirm = TRUE, overwrite = TRUE, outfile = tempdir())
download_data(dataset, "text/csv", FALSE, 1, noconfirm = TRUE)
download_data(dataset, "text/csv", FALSE, 1, noconfirm = TRUE, overwrite = TRUE)
download_data(dataset, "application/pdf", TRUE, noconfirm = TRUE, outfile = tempdir())
}
}
